#ifndef HwdEUART_H
#define HwdEUART_H

#include "EUARTDef.h"

// Hwc: Hardware Core(Control)
//      this layer will check complex hardware behavior.
// Hwd: Hardware Driver Core(interface)
//      this layer will do a translation of parameters between app and hardware.
// Specific OS Driver Layer
//      this layer will implement the Asynchronous I/O Programming
//      between interrupt event and controller request.
// Library Layer
//      this layer will force on the control flow of the controller.


//----
//  HwcEUART_func
//

// see EUARTDef.h
typedef struct _EUARTFIFOConfigure HwcEUARTFIFOConfigure, *PHwcEUARTFIFOConfigure;

typedef struct _EUARTPortConfigure HwcEUARTPortConfigure, *PHwcEUARTPortConfigure;

typedef struct _EUARTInterrupt HwcEUARTInterrupt, *PHwcEUARTInterrupt;

typedef struct _EUARTInterrupt HwcEUARTInterruptStatus, *PHwcEUARTInterruptStatus;

typedef struct _EUARTLineStatus HwcEUARTLineStatus, *PHwcEUARTLineStatus;

typedef struct _EUARTModemStatus HwcEUARTModemStatus, *PHwcEUARTModemStatus;

typedef struct _EUARTDMAStatus HwcEUARTDMAStatus, *PHwcEUARTDMAStatus;

typedef struct _EUARTDMAInterrupt HwcEUARTDMAInterrupt, *PHwcEUARTDMAInterrupt;

typedef struct _EUARTDMAInterruptStatus HwcEUARTDMAInterruptStatus, *PHwcEUARTDMAInterruptStatus;

typedef struct _HwcEUART
{
    // Hardware Interface
    PMappedBusAddress           hMappedRegisters;
    PMappedBusAddress           hMappedRegisters_DMA;
    
    // to reduce the trafic of the system bus,
    // we can define a medium (member) which corresponds to hardware interface.
    // we suggests that the global information can be a medium member.
    
    HwcEUARTFIFOConfigure       sHwcEUARTFIFOConfigure;
    
    ULONG                       BRDIV;
    
    HwcEUARTPortConfigure       sHwcEUARTPortConfigure;
    
    HwcEUARTInterrupt           sHwcEUARTInterrupt;
    
    HwiModemControlReg          sHwiModemControlReg;
    
}HwcEUART, *PHwcEUART;

FRSTATUS
HwcEUART_Initialize(  // initializing structure
    IN      PHwcEUART           hHwcEUART,
    IN      PMappedBusAddress   hMappedRegisters,
    IN      PMappedBusAddress   hMappedRegisters_DMA
    );
    
FRSTATUS
HwcEUART_InitHW(      // initializing hardware, off & reset
    IN      PHwcEUART           hHwcEUART
    );

FRSTATUS
HwcEUART_ShowAll(
    IN      PHwcEUART           hHwcEUART
    );

FRSTATUS
HwcEUART_SetBaudRateDIV(
    IN      PHwcEUART                   hHwcEUART,
    IN      ULONG                       BRDIV
    );

FRSTATUS
HwcEUART_SetFIFOConfigure(
    IN      PHwcEUART                   hHwcEUART,
    IN      PHwcEUARTFIFOConfigure      pHwcEUARTFIFOConfigure
    );

FRSTATUS
HwcEUART_GetFIFOConfigure(
    IN      PHwcEUART                   hHwcEUART,
        OUT PHwcEUARTFIFOConfigure      pHwcEUARTFIFOConfigure
    );

FRSTATUS
HwcEUART_SetPortConfigure(
    IN      PHwcEUART                   hHwcEUART,
    IN      PHwcEUARTPortConfigure      pHwcEUARTPortConfigure
    );

FRSTATUS
HwcEUART_GetPortConfigure(
    IN      PHwcEUART                   hHwcEUART,
        OUT PHwcEUARTPortConfigure      pHwcEUARTPortConfigure
    );

/*
FRSTATUS
HwcEUART_GetGlobalStatus(
    IN      PHwcEUART                   hHwcEUART,
        OUT PHwcEUARTGlobalStatus       pHwcEUARTGlobalStatus
    );
*/

FRSTATUS
HwcEUART_SetInterruptEnable(
    IN      PHwcEUART                   hHwcEUART,
    IN      PHwcEUARTInterrupt          pHwcEUARTInterrupt
    );

FRSTATUS
HwcEUART_GetInterruptEnable(
    IN      PHwcEUART                   hHwcEUART,
        OUT PHwcEUARTInterrupt          pHwcEUARTInterrupt
    );

FRSTATUS
HwcEUART_GetInterruptStatus(
    IN      PHwcEUART                   hHwcEUART,
        OUT PHwcEUARTInterruptStatus    pHwcEUARTInterruptStatus
    );

FRSTATUS
HwcEUART_ClearPendingInterrupts(
    IN      PHwcEUART                   hHwcEUART
    );

/*
FRSTATUS
HwcEUART_HardwareReset(
    IN      PHwcEUART             hHwcEUART
    );

FRSTATUS
HwcEUART_ControllerReset( // a light reset
    IN      PHwcEUART             hHwcEUART
    );
*/

FRSTATUS
HwcEUART_ResetInterrupt(
    IN      PHwcEUART           hHwcEUART
    );

FRSTATUS
HwcEUART_ResetFIFOControl(
    IN      PHwcEUART           hHwcEUART
    );

FRSTATUS
HwcEUART_ResetLineControl(
    IN      PHwcEUART               hHwcEUART
    );

FRSTATUS
HwcEUART_ResetModemControl(
    IN      PHwcEUART               hHwcEUART
    );

FRSTATUS
HwcEUART_ReadRxBuffer8(
    IN      PHwcEUART           hHwcEUART,
        OUT PULONG              pData
    );

FRSTATUS
HwcEUART_WriteTxBuffer8(
    IN      PHwcEUART           hHwcEUART,
    IN      ULONG               Data
    );

FRSTATUS
HwcEUART_ReadLineStatus(
    IN      PHwcEUART               hHwcEUART,
        OUT PHwcEUARTLineStatus     pHwcEUARTLineStatus
    );

FRSTATUS
HwcEUART_ReadModemStatus(
    IN      PHwcEUART               hHwcEUART,
        OUT PHwcEUARTModemStatus    pHwcEUARTModemStatus
    );

FRSTATUS
HwcEUART_StartTransmitBreak(
    IN      PHwcEUART           hHwcEUART
    );

FRSTATUS
HwcEUART_StopTransmitBreak(
    IN      PHwcEUART           hHwcEUART
    );

FRSTATUS
HwcEUART_SetDTRPin(
    IN      PHwcEUART           hHwcEUART,
    IN      ULONG               DTRPin      // 0: High, 1: Low
    );

FRSTATUS
HwcEUART_SetRTSPin(
    IN      PHwcEUART           hHwcEUART,
    IN      ULONG               RTSPin      // 0: High, 1: Low
    );

FRSTATUS
HwcEUART_SetOut1Pin(
    IN      PHwcEUART           hHwcEUART,
    IN      ULONG               Out1Pin     // 0: High, 1: Low
    );

FRSTATUS
HwcEUART_SetOut2Pin(
    IN      PHwcEUART           hHwcEUART,
    IN      ULONG               Out2Pin     // 0: High, 1: Low
    );

FRSTATUS
HwcEUART_SetScratchpad(
    IN      PHwcEUART           hHwcEUART,
    IN      ULONG               Data
    );

FRSTATUS
HwcEUART_GetScratchpad(
    IN      PHwcEUART           hHwcEUART,
        OUT PULONG              pData
    );
    
// EUART DMA mode

FRSTATUS
HwcEUART_HardResetDMA(
    IN      PHwcEUART           hHwcEUART
    );

FRSTATUS
HwcEUART_DMADebugBit(
    IN      PHwcEUART           hHwcEUART,
    IN      ULONG               DebugBit
    );

FRSTATUS
HwcEUART_EnableDMA(
    IN      PHwcEUART           hHwcEUART
    );

FRSTATUS
HwcEUART_DisbleDMA(
    IN      PHwcEUART           hHwcEUART
    );

FRSTATUS
HwcEUART_SetRxSegmentTriggerLevel(
    IN      PHwcEUART           hHwcEUART,
    IN      ULONG               RxSegmentTriggerLevel
    );

FRSTATUS
HwcEUART_GetTxSegmentReady(
    IN      PHwcEUART           hHwcEUART,
        OUT PULONG              pTxSegment0Ready,
        OUT PULONG              pTxSegment1Ready
    );


FRSTATUS
HwcEUART_GetRxSegmentReady(
    IN      PHwcEUART           hHwcEUART,
        OUT PULONG              pRxSegment0Ready,
        OUT PULONG              pRxSegment1Ready
    );

FRSTATUS
HwcEUART_TxSegment0Ready(
    IN      PHwcEUART           hHwcEUART
    );

FRSTATUS
HwcEUART_TxSegment1Ready(
    IN      PHwcEUART           hHwcEUART
    );

FRSTATUS
HwcEUART_RxSegment0Ready(
    IN      PHwcEUART           hHwcEUART
    );

FRSTATUS
HwcEUART_RxSegment1Ready(
    IN      PHwcEUART           hHwcEUART
    );

FRSTATUS
HwcEUART_GetDMAStatus(
    IN      PHwcEUART           hHwcEUART,
        OUT PHwcEUARTDMAStatus  pHwcEUARTDMAStatus
    );

FRSTATUS
HwcEUART_SetDMATxBufferAddress(
    IN      PHwcEUART           hHwcEUART,
    IN      ULONG               Address32bit
    );

FRSTATUS
HwcEUART_SetDMARxBufferAddress(
    IN      PHwcEUART           hHwcEUART,
    IN      ULONG               Address32bit
    );

FRSTATUS
HwcEUART_SetDMAInterruptEnable(
    IN      PHwcEUART               hHwcEUART,
    IN      PHwcEUARTDMAInterrupt   pHwcEUARTDMAInterrupt
    );

FRSTATUS
HwcEUART_GetDMAInterruptEnable(
    IN      PHwcEUART               hHwcEUART,
        OUT PHwcEUARTDMAInterrupt   pHwcEUARTDMAInterrupt
    );

FRSTATUS
HwcEUART_GetDMAInterruptStatus(
    IN      PHwcEUART                       hHwcEUART,
        OUT PHwcEUARTDMAInterruptStatus     pHwcEUARTDMAInterruptStatus
    );

FRSTATUS
HwcEUART_SetDMAInterruptStatus(
    IN      PHwcEUART                       hHwcEUART,
    IN      PHwcEUARTDMAInterruptStatus     pHwcEUARTDMAInterruptStatus
    );

FRSTATUS
HwcEUART_SetTx0DataLength(
    IN      PHwcEUART           hHwcEUART,
    IN      ULONG               DataLength
    );

FRSTATUS
HwcEUART_SetTx1DataLength(
    IN      PHwcEUART           hHwcEUART,
    IN      ULONG               DataLength
    );

FRSTATUS
HwcEUART_GetRx0DataCount(
    IN      PHwcEUART           hHwcEUART,
        OUT PULONG              pDataCount
    );

FRSTATUS
HwcEUART_GetRx1DataCount(
    IN      PHwcEUART           hHwcEUART,
        OUT PULONG              pDataCount
    );
    

// Hwd: Hardware Driver Core(interface)
// in this level, we dont handle synchonizaiton between IO action and interrupt.
// the ioctl level will handle this. like waiting for interrut event.

//----
//  HwdEUART_func
//

// see EUARTDef.h
typedef struct _EUARTFIFOConfigure HwdEUARTFIFOConfigure, *PHwdEUARTFIFOConfigure;

typedef struct _EUARTPortConfigure HwdEUARTPortConfigure, *PHwdEUARTPortConfigure;

typedef struct _EUARTInterrupt HwdEUARTInterrupt, *PHwdEUARTInterrupt;

typedef struct _EUARTVolatileInfo HwdEUARTVolatileInfo, *PHwdEUARTVolatileInfo;

typedef struct _EUARTLineStatus HwdEUARTLineStatus, *PHwdEUARTLineStatus;

typedef struct _EUARTModemStatus HwdEUARTModemStatus, *PHwdEUARTModemStatus;

typedef struct _EUARTDMAInterrupt HwdEUARTDMAInterrupt, *PHwdEUARTDMAInterrupt;


typedef struct _HwdEUART
{
    PVOID                       pcidev;
    
    // System Bus Info
    ULONG                       BusNumber;
    ULONG                       DeviceNumber;
    ULONG                       FunctionNumber;
    
    ULONG                       PortID;
    
    // Hardware Interface
    //MappedBusAddress            sMappedRegisters;
    PMappedBusAddress           hMappedRegisters;
    
    //MappedBusAddress            sMappedRegisters_DMA;
    PMappedBusAddress           hMappedRegisters_DMA;
    
    // Hardware Core(Control)
    HwcEUART                    sHwcEUART;
    PHwcEUART                   hHwcEUART;
    
    // Driver Core Data
    ULONG                       DMAEnable;
    SPCommonBuffer              DMACommonBuffer;
    //SPCommonBuffer              DMACommonBufferTx;
    //SPCommonBuffer              DMACommonBufferRx;
    PVOID                       Tx0Buffer;
    PVOID                       Tx1Buffer;
    PVOID                       Rx0Buffer;
    PVOID                       Rx1Buffer;
    ULONG                       TxSegmentIndication;
    ULONG                       RxSegmentIndication; 
    
    //ULONG                       BytePattern;
    
    ULONG                       TxSegment0Ready;
    ULONG                       TxSegment1Ready;
                                // set on HwdEUART_DMAWriteTxBuffer
                                // clear on DPCForISR

    
    // Synchronization
    // use SpinLock if Task and DPC will access share resource.
    // use Semaphore if Task and Task will access share resource.
    
    //SPSpinLock                  sSPSpinLockDPC;
    //SPSemaphore                 sSPSemaphoreTask;
    
    //SPSpinLock                  sSPSpinLockDPC;     // some of registers need synchron protection
                                                    // HwdEUART_StartTransmitBreak
                                                    // HwdEUART_StopTransmitBreak
                                                    // HwdEUART_SetDTRPin
                                                    // HwdEUART_SetRTSPin
                                                    // HwdEUART_SetOut1Pin
                                                    // HwdEUART_SetOut2Pin
    
    ULONG                       LastRx0Count;
    ULONG                       LastRx1Count;
    
    //SPTime                      sSPTime_TxRx0;
    //SPTime                      sSPTime_TxRx1;
    
}HwdEUART, *PHwdEUART;


/*
FRSTATUS
HwdEUART_GetSingleton(
    IN  OUT PHwdEUART             *phHwdEUART
    );

FRSTATUS
HwdEUART_Create(
    IN  OUT PHwdEUART             *phHwdEUART
    );

FRSTATUS
HwdEUART_Delete(
    IN  OUT PHwdEUART             *phHwdEUART
    );
*/

FRSTATUS
HwdEUART_Initialize(  // initializing struct data
    IN      PHwdEUART             hHwdEUART
    );

// hardware resource open & close 

FRSTATUS
HwdEUART_SetMappedRegisters(
    IN      PHwdEUART           hHwdEUART,
    IN      PMappedBusAddress   hMappedRegisters_UART,
    IN      PMappedBusAddress   hMappedRegisters_DMA
    );

FRSTATUS
HwdEUART_OpenDevice(
    IN      PHwdEUART           hHwdEUART,
    IN      PVOID               pcidev,
    IN      ULONG               BusNumber,
    IN      ULONG               DeviceNumber,
    IN      ULONG               FunctionNumber,
    IN      ULONG               PortID
    );

FRSTATUS
HwdEUART_CloseDevice(
    IN      PHwdEUART           hHwdEUART
    );

// hardware initialization

FRSTATUS
HwdEUART_InitHW(
    IN      PHwdEUART           hHwdEUART
    );

FRSTATUS
HwdEUART_InitDMA(
    IN      PHwdEUART           hHwdEUART
    );


// interrupt ISR and DCPForISR

FRSTATUS
HwdEUART_ISR(
    IN      PHwdEUART               hHwdEUART,
        OUT PULONG                  pbInterrupt,
        OUT PHwdEUARTInterrupt      pHwdEUARTInterrupt,
        OUT PHwdEUARTVolatileInfo   pHwdEUARTVolatileInfo
    );

FRSTATUS
HwdEUART_ISREasy(
    IN      PHwdEUART               hHwdEUART,
        OUT PULONG                  pbInterrupt,
        OUT PHwdEUARTInterrupt      pHwdEUARTInterrupt,
        OUT PHwdEUARTVolatileInfo   pHwdEUARTVolatileInfo
    );


FRSTATUS
HwdEUART_DMAISR(
    IN      PHwdEUART               hHwdEUART,
        OUT PULONG                  pbInterrupt,
        OUT PHwdEUARTInterrupt      pHwdEUARTInterrupt,
        OUT PHwdEUARTVolatileInfo   pHwdEUARTVolatileInfo
    );

FRSTATUS
HwdEUART_DMAISREasy(
    IN      PHwdEUART               hHwdEUART,
        OUT PULONG                  pbInterrupt,
        OUT PHwdEUARTInterrupt      pHwdEUARTInterrupt,
        OUT PHwdEUARTVolatileInfo   pHwdEUARTVolatileInfo
    );

FRSTATUS
HwdEUART_DCPForISR(
    IN      PHwdEUART               hHwdEUART,
    IN      PHwdEUARTInterrupt      pHwdEUARTInterrupt,
    IN      PHwdEUARTVolatileInfo   pHwdEUARTVolatileInfo
    );

// interrupt control

FRSTATUS
HwdEUART_EnableInterrupt(
    IN      PHwdEUART               hHwdEUART,
    IN      PHwdEUARTInterrupt      pHwdEUARTInterrupt // TRUE to Enable
    );
    
FRSTATUS
HwdEUART_DisableInterrupt(
    IN      PHwdEUART               hHwdEUART,
    IN      PHwdEUARTInterrupt      pHwdEUARTInterrupt // TRUE to Disable
    );

FRSTATUS
HwdEUART_EnableDMAInterrupt(
    IN      PHwdEUART               hHwdEUART
    );
    
FRSTATUS
HwdEUART_DisableDMAInterrupt(
    IN      PHwdEUART               hHwdEUART
    );

// configuration

FRSTATUS
HwdEUART_SetBaudRateDIV(
    IN      PHwdEUART                   hHwdEUART,
    IN      ULONG                       BRDIV
    );
    
FRSTATUS
HwdEUART_SetFIFOConfigure(
    IN      PHwdEUART                   hHwdEUART,
    IN      PHwdEUARTFIFOConfigure      pHwdEUARTFIFOConfigure
    );

FRSTATUS
HwdEUART_GetFIFOConfigure(
    IN      PHwdEUART                   hHwdEUART,
        OUT PHwdEUARTFIFOConfigure      pHwdEUARTFIFOConfigure
    );

FRSTATUS
HwdEUART_SetPortConfigure(
    IN      PHwdEUART                   hHwdEUART,
    IN      PHwdEUARTPortConfigure      pHwdEUARTPortConfigure
    );

FRSTATUS
HwdEUART_GetPortConfigure(
    IN      PHwdEUART                   hHwdEUART,
        OUT PHwdEUARTPortConfigure      pHwdEUARTPortConfigure
    );

/*
FRSTATUS
HwdEUART_GetGlobalStatus(
    IN      PHwdEUART               hHwdEUART,
        OUT PHwdEUARTGlobalStatus   pHwdEUARTGlobalStatus
    );
*/

// control function

/*
FRSTATUS
HwdEUART_HardwareReset(
    IN      PHwdEUART           hHwdEUART
    );

FRSTATUS
HwdEUART_ControllerReset(
    IN      PHwdEUART           hHwdEUART
    );
*/

FRSTATUS
HwdEUART_Start(   // empty function
    IN      PHwdEUART           hHwdEUART
    );
    
FRSTATUS
HwdEUART_Stop(    // empty function
    IN      PHwdEUART           hHwdEUART
    );

FRSTATUS
HwdEUART_ReadRxBuffer8(
    IN      PHwdEUART           hHwdEUART,
        OUT PULONG              pData
    );

FRSTATUS
HwdEUART_WriteTxBuffer8(
    IN      PHwdEUART           hHwdEUART,
    IN      ULONG               Data
    );

FRSTATUS
HwdEUART_ReadLineStatus(
    IN      PHwdEUART               hHwdEUART,
        OUT PHwdEUARTLineStatus     pHwdEUARTLineStatus
    );

FRSTATUS
HwdEUART_ReadModemStatus(
    IN      PHwdEUART               hHwdEUART,
        OUT PHwdEUARTModemStatus    pHwdEUARTModemStatus
    );

FRSTATUS
HwdEUART_StartTransmitBreak(
    IN      PHwdEUART           hHwdEUART
    );

FRSTATUS
HwdEUART_StopTransmitBreak(
    IN      PHwdEUART           hHwdEUART
    );

FRSTATUS
HwdEUART_SetDTRPin(
    IN      PHwdEUART           hHwdEUART,
    IN      ULONG               DTRPin      // 0: High, 1: Low
    );

FRSTATUS
HwdEUART_SetRTSPin(
    IN      PHwdEUART           hHwdEUART,
    IN      ULONG               RTSPin      // 0: High, 1: Low
    );

FRSTATUS
HwdEUART_SetOut1Pin(
    IN      PHwdEUART           hHwdEUART,
    IN      ULONG               Out1Pin     // 0: High, 1: Low
    );

FRSTATUS
HwdEUART_SetOut2Pin(
    IN      PHwdEUART           hHwdEUART,
    IN      ULONG               Out2Pin     // 0: High, 1: Low
    );

FRSTATUS
HwdEUART_SetScratchpad(
    IN      PHwdEUART           hHwdEUART,
    IN      ULONG               Data
    );

FRSTATUS
HwdEUART_GetScratchpad(
    IN      PHwdEUART           hHwdEUART,
        OUT PULONG              pData
    );

FRSTATUS
HwdEUART_HardResetDMA(
    IN      PHwdEUART           hHwdEUART
    );

FRSTATUS
HwdEUART_EnableDMA(
    IN      PHwdEUART           hHwdEUART
    );

FRSTATUS
HwdEUART_DisableDMA(
    IN      PHwdEUART           hHwdEUART
    );

FRSTATUS
HwdEUART_GetDMAEnable(
    IN      PHwdEUART           hHwdEUART,
        OUT PULONG              pDMAEnable
    );

FRSTATUS
HwdEUART_SetRxSegmentTriggerLevel(
    IN      PHwdEUART           hHwdEUART,
    IN      ULONG               RxSegmentTriggerLevel   // 0:128 1:64: 2:32 3:16 4:8 5:4 6:2 7:1
    );

FRSTATUS
HwdEUART_DMATxEmpty(
    IN      PHwdEUART           hHwdEUART,
        OUT PULONG              pbTxEmpty
    );

FRSTATUS
HwdEUART_DMAWriteTxBuffer(
    IN      PHwdEUART           hHwdEUART,
    IN      PVOID               pDataBuffer,
    IN      ULONG               DataBufferLength    // MaxTxBufferSize 128bytes
    );

FRSTATUS
HwdEUART_DMAAllEmpty(
    IN      PHwdEUART           hHwdEUART,
        OUT PULONG              pbAllEmpty
    );

FRSTATUS
HwdEUART_DMAShowAll(
    IN      PHwdEUART           hHwdEUART
    );


FRSTATUS
HwdEUART_SetHwiReg(
    IN      PHwdEUART           hHwdEUART,
    IN      ULONG               RegID,
    IN      PVOID               pHwiReg,
    IN      ULONG               SizeOfHwiReg
    );
    
FRSTATUS
HwdEUART_GetHwiReg(
    IN      PHwdEUART           hHwdEUART,
    IN      ULONG               RegID,
        OUT PVOID               pHwiReg,
    IN      ULONG               SizeOfHwiReg
    );

FRSTATUS
HwdEUART_SetReg(
    IN      PHwdEUART           hHwdEUART,
    IN      ULONG               RegID,
    IN      ULONG               Value
    );
    
FRSTATUS
HwdEUART_GetReg(
    IN      PHwdEUART           hHwdEUART,
    IN      ULONG               RegID,
        OUT PULONG              pValue
    );

VOID
HwdEUART_ComputeBRDIV(
    IN      ULONG                   SourceClock,
    IN      ULONG                   ClockDIV,
    IN      ULONG                   bAdaptiveBaudRate,
    IN      ULONG                   BaudRate,
        OUT PULONG                  pBRDIV      // 0 if not adaptive BRDIV
    );

/*
EUART SoftReset
1. reset Modem Control and disable out2. global interrupt
2. reset Line Control Register
3. clear RxBuffer and RxFIFO, then re-enable RxFIFO
    If there is a data in RxBuffer, we clear RxFIFO, then enable it.
    This will cause a line status interrupt to occur. so we should do the following steps.
    a. disable interrupt
    b. diable RxFIFO
    b. clear RxBuffer until DataReady = 0
    c. RxFIFO clear and enable RxFIFO
4. set Line Control Register to the default.
5. read modem status until no change occurs //????
6. clear pending interrupts (Tx empty)
7. enable out2. global interrupt
*/

VOID
HwdEUART_HardReset( // include BRDIV and interrupt
    IN      PHwdEUART               hHwdEUART
    );

VOID
HwdEUART_SoftReset( // this dont involve enabling out2.
    IN      PHwdEUART               hHwdEUART,
    IN      PEUARTFIFOConfigure     pEUARTFIFOConfigure,
    IN      PEUARTPortConfigure     pEUARTPortConfigure
    );





#endif
